/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import noppes.npcs.client.gui.util.MarkUp;

public class LineData {
    public final String text;
    public int start;
    public int end;
    private final Map<List<MarkUp>, String> data = new HashMap<List<MarkUp>, String>();

    public LineData(String textIn, int startIn, int endIn) {
        this.text = textIn;
        this.start = startIn;
        this.end = endIn;
    }

    public String getFormattedString(List<MarkUp> makeup) {
        if (this.data.containsKey(makeup)) {
            return this.data.get(makeup);
        }
        StringBuilder builder = new StringBuilder(this.text);
        int found = 0;
        for (MarkUp entry : makeup) {
            if (entry.start >= this.start && entry.start < this.end) {
                builder.insert(entry.start - this.start + found * 2, '\uffff' + Character.toString(entry.c));
                ++found;
            }
            if (entry.start < this.start && entry.end > this.start) {
                builder.insert(0, '\uffff' + Character.toString(entry.c));
                ++found;
            }
            if (entry.end < this.start || entry.end >= this.end) continue;
            builder.insert(entry.end - this.start + found * 2, '\uffff' + Character.toString('r'));
            ++found;
        }
        this.data.put(makeup, builder.toString());
        return this.data.get(makeup);
    }
}

